@extends('layout.main')

@section('title', 'Order Details')

@section('content')
    <section class="page-content luxury-order-page">
        <!-- Luxury Page Header with Gold Accents -->
        <div class="luxury-header">
            <div class="container">
                <div class="luxury-page-header">
                    <div class="luxury-breadcrumb">
                        <a href="{{ route('profile') }}" class="luxury-link">Profile</a>
                        <span class="luxury-divider">›</span>
                        <a href="{{ route('order-history') }}" class="luxury-link">Order History</a>
                        <span class="luxury-divider">›</span>
                        <span class="luxury-current">Order ORD-001</span>
                    </div>
                    <h1 class="luxury-title">Your Luxury Order</h1>
                    <p class="luxury-subtitle">Timeless treasures, meticulously crafted for you</p>
                </div>
            </div>
        </div>

        <div class="container luxury-container">
            <!-- Back Button and Status Banner Row -->
            <div class="luxury-top-row">
                <!-- Back Navigation -->
                <div class="luxury-back-nav">
                    <a href="{{ route('profile') }}" class="luxury-back-btn">
                        <i data-feather="arrow-left" class="me-2"></i>
                        Return to Profile
                    </a>
                </div>

                <!-- Order Status Banner -->
                <div class="luxury-status-banner">
                    <div class="luxury-status-content">
                        <div class="luxury-status-icon">
                            <i data-feather="check-circle"></i>
                        </div>
                        <div class="luxury-status-text">
                            <h3>Order Delivered Successfully</h3>
                            <!--   <p>Your luxury treasures have arrived safely on January 17, 2024</p> -->
                        </div>
                        <!-- <div class="luxury-status-badge">
                <span class="luxury-badge">ORD-001</span>
              </div> -->
                    </div>
                </div>
            </div>

            <!-- Main Content Grid -->
            <div class="luxury-grid">
                <!-- Left Column - Order Details -->
                <div class="luxury-main-content">
                    <!-- Luxury Items Section -->
                    <div class="luxury-section">
                        <div class="luxury-section-header">
                            <h4 class="luxury-section-title">
                                <i data-feather="diamond" class="luxury-icon"></i>
                                Order ID <div class="luxury-status-badge">
                                    <span class="luxury-badge">ORD-001</span>
                                </div>
                            </h4>
                        </div>

                        <!-- Luxury Item 1 -->
                        <div class="luxury-item-card">
                            <div class="luxury-item-image">
                                <img src="{{ asset('img/p1.jpg') }}" alt="Diamond Illusion Necklace" class="luxury-img">
                                <!--   <div class="luxury-item-badge">Premium</div> -->
                            </div>
                            <div class="luxury-item-details">
                                <h5 class="luxury-item-name">Diamond Illusion Necklace</h5>
                                <p class="luxury-item-desc">18K White Gold with Brilliant Cut Diamonds</p>
                                <div class="luxury-item-specs">
                                    <span class="luxury-spec">Quantity: 1</span>
                                    <span class="luxury-spec">Size: 18"</span>
                                    <span class="luxury-spec">Gold: 18K</span>
                                </div>
                            </div>
                            <div class="luxury-item-price">
                                <span class="luxury-price">$1,899.99</span>
                            </div>
                        </div>

                        <!-- Luxury Item 2 -->
                        <div class="luxury-item-card">
                            <div class="luxury-item-image">
                                <img src="{{ asset('img/p2.jpg') }}" alt="Pearl Elegance Earrings" class="luxury-img">
                                <!-- <div class="luxury-item-badge">Premium</div> -->
                            </div>
                            <div class="luxury-item-details">
                                <h5 class="luxury-item-name">Pearl Elegance Earrings</h5>
                                <p class="luxury-item-desc">Cultured South Sea Pearls with Gold Setting</p>
                                <div class="luxury-item-specs">
                                    <span class="luxury-spec">Quantity: 1</span>
                                    <span class="luxury-spec">Pearl: 10mm</span>
                                    <span class="luxury-spec">Gold: 14K</span>
                                </div>
                            </div>
                            <div class="luxury-item-price">
                                <span class="luxury-price">$599.99</span>
                            </div>
                        </div>
                    </div>

                    <!-- Order Journey Timeline -->
                    <div class="luxury-section">
                        <div class="luxury-section-header">
                            <h4 class="luxury-section-title">
                                <i data-feather="clock" class="luxury-icon"></i>
                                Your Order Journey
                            </h4>
                        </div>

                        <div class="luxury-timeline">
                            <div class="luxury-timeline-item completed">
                                <div class="luxury-timeline-marker">
                                    <i data-feather="shopping-bag"></i>
                                </div>
                                <div class="luxury-timeline-content">
                                    <h6>Order Placed</h6>
                                    <span class="luxury-timeline-date">Jan 15, 2024 • 2:30 PM</span>
                                    <p>Your luxury selection was confirmed and processing began immediately.</p>
                                </div>
                            </div>

                            <div class="luxury-timeline-item completed">
                                <div class="luxury-timeline-marker">
                                    <i data-feather="settings"></i>
                                </div>
                                <div class="luxury-timeline-content">
                                    <h6>Crafting & Quality Check</h6>
                                    <span class="luxury-timeline-date">Jan 15, 2024 • 6:45 PM</span>
                                    <p>Master artisans prepared your pieces with meticulous attention to detail.</p>
                                </div>
                            </div>

                            <div class="luxury-timeline-item completed">
                                <div class="luxury-timeline-marker">
                                    <i data-feather="truck"></i>
                                </div>
                                <div class="luxury-timeline-content">
                                    <h6>Shipped with Care</h6>
                                    <span class="luxury-timeline-date">Jan 16, 2024 • 10:15 AM</span>
                                    <p>Your treasures embarked on their journey with premium secure shipping.</p>
                                </div>
                            </div>

                            <div class="luxury-timeline-item current">
                                <div class="luxury-timeline-marker">
                                    <i data-feather="home"></i>
                                </div>
                                <div class="luxury-timeline-content">
                                    <h6>Delivered Safely</h6>
                                    <span class="luxury-timeline-date">Jan 17, 2024 • 3:20 PM</span>
                                    <p>Your luxury jewelry arrived at its forever home, ready to be cherished.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Right Column - Summary & Actions -->
                <div class="luxury-sidebar">
                    <!-- Investment Summary -->
                    <div class="luxury-summary-card">
                        <div class="luxury-summary-header">
                            <h5 class="luxury-summary-title">
                                <i data-feather="dollar-sign"></i>
                                Investment Summary
                            </h5>
                        </div>
                        <div class="luxury-summary-content">
                            <div class="luxury-summary-item">
                                <span>Collection Subtotal</span>
                                <span>$2,499.98</span>
                            </div>
                            <div class="luxury-summary-item luxury-complimentary">
                                <span>Shipping</span>
                                <span class="luxury-free">Free</span>
                            </div>
                            <div class="luxury-summary-item">
                                <span>Tax & Duties</span>
                                <span>$199.99</span>
                            </div>
                            <!--  <div class="luxury-summary-divider"></div> -->
                            <div class="luxury-summary-total">
                                <span>Total Investment</span>
                                <span class="luxury-total-price">$2,699.97</span>
                            </div>
                        </div>
                    </div>

                    <!-- Delivery Information -->
                    <div class="luxury-info-card">
                        <div class="luxury-info-header">
                            <h5 class="luxury-info-title">
                                <i data-feather="map-pin"></i>
                                Delivery Address
                            </h5>
                        </div>
                        <div class="luxury-info-content">
                            <div class="luxury-address">
                                <strong>Sarah Johnson</strong><br>
                                123 Madison Avenue<br>
                                New York, NY 10016<br>
                                United States
                            </div>
                            <div class="luxury-contact">
                                <i data-feather="phone"></i>
                                +1 (555) 123-4567
                            </div>
                        </div>
                    </div>

                    <!-- Payment Method -->
                    <div class="luxury-info-card">
                        <div class="luxury-info-header">
                            <h5 class="luxury-info-title">
                                <i data-feather="credit-card"></i>
                                Payment Method
                            </h5>
                        </div>
                        <div class="luxury-info-content">
                            <div class="luxury-payment">
                                <div class="luxury-payment-icon">
                                    <i data-feather="credit-card"></i>
                                </div>
                                <div class="luxury-payment-details">
                                    <strong>Visa ending in 4567</strong><br>
                                    <span>Expires 12/2025</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="luxury-actions">
                        <button class="luxury-btn luxury-btn-primary">
                            <i data-feather="truck"></i>
                            Track Your Treasure
                        </button>
                        <button class="luxury-btn luxury-btn-outline">
                            <i data-feather="file-text"></i>
                            Download Invoice
                        </button>
                        <button class="luxury-btn luxury-btn-outline">
                            <i data-feather="headphones"></i>
                            Contact Concierge
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize Feather icons
            if (typeof feather !== 'undefined') {
                feather.replace();
            }

            // Add subtle animations
            const luxuryItems = document.querySelectorAll('.luxury-item-card');
            luxuryItems.forEach((item, index) => {
                item.style.animationDelay = `${index * 0.1}s`;
                item.classList.add('animate__animated', 'animate__fadeInUp');
            });

            // Add hover effects for buttons
            const buttons = document.querySelectorAll('.luxury-btn');
            buttons.forEach(button => {
                button.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-2px)';
                });
                button.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                });
            });
        });
    </script>
@endpush
