@extends('layout.main')

@section('title', 'Checkout')

@section('content')
    <div class="page-content cart-page">
        <div class="container">

            <div class="page-header">
                <h1>
                    Checkout
                </h1>
                <p><a href="{{ url('/') }}">Home</a> / Checkout
                </p>
            </div>
            <div class="checkout-container">

                <div class="row">
                    <div class="col-lg-6">
                        <div class="address-section">
                            <div class="billing-address">
                                <h2>Billing Address</h2>
                                <div class="address-item selected">
                                    <input type="checkbox" checked />
                                    <div class="address-details">
                                        <p>10672 Kenai Spur Hwy, Kenai, Alaska, 99611, US</p>
                                        <p>Phone : (907) 283-8799</p>
                                        <p>Country : US</p>
                                    </div>
                                </div>
                            </div>

                            <div class="shipping-address">

                                <div class="shipping-head">
                                    <h2>Shipping Address</h2>
                                    <button class="add-new-btn" data-bs-toggle="modal" data-bs-target="#shipping-addres">Add
                                        New</button>
                                </div>
                                <div class="address-item selected">
                                    <input type="checkbox" checked />
                                    <div class="address-details">
                                        <p>10672 Kenai Spur Hwy, Kenai, Alaska, 99611, US</p>
                                        <p>Phone : (907) 283-8799 <span class="country">Country : US</span></p>
                                    </div>
                                    <button class="edit-btn">&#9998;</button>
                                </div>
                                <hr />
                                <div class="address-item">
                                    <input type="checkbox" />
                                    <div class="address-details">
                                        <p>10672 Kenai Spur Hwy, Kenai, Alaska, 99611, US</p>
                                        <p>Phone : (907) 283-8799 <span class="country">Country : US</span></p>
                                    </div>
                                    <button class="edit-btn">&#9998;</button>
                                </div>
                                <hr />
                                <div class="address-item">
                                    <input type="checkbox" />
                                    <div class="address-details">
                                        <p>10672 Kenai Spur Hwy, Kenai, Alaska, 99611, US</p>
                                        <p>Phone : (907) 283-8799 <span class="country">Country : US</span></p>
                                    </div>
                                    <button class="edit-btn">&#9998;</button>
                                </div>
                                <hr />
                                <div class="address-item">
                                    <input type="checkbox" />
                                    <div class="address-details">
                                        <p>10672 Kenai Spur Hwy, Kenai, Alaska, 99611, US</p>
                                        <p>Phone : (907) 283-8799 <span class="country">Country : US</span></p>
                                    </div>
                                    <button class="edit-btn">&#9998;</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="summary-section">


                            <div class="summary-header">
                                <h3>Summary</h3>
                                <span class="total-items">Total Item : 3</span>
                            </div>
                            <div class="summary-items">
                                <div class="summary-item">
                                    <img src="{{ asset('img/pd.webp') }}" alt="Layer Cake Necklace Set" />
                                    <div class="item-info">
                                        <h4>Layer Cake Necklace Set</h4>
                                        <p class="item-desc">pendant, ethical white gold, diamonds</p>
                                        <p class="item-price">$ 2,630</p>
                                    </div>
                                    <div class="cart-quantity">
                                        <div class="pd-btn">
                                            <div class="pd-quantity">
                                                <button class="quantity-less" type="button"><i data-feather="minus"></i>
                                                </button>
                                                <span class="quantity-count"><input type="text" value="1"
                                                        min="1" pattern="[0-9]*" inputmode="numeric"
                                                        class="quantity-input"></span>
                                                <button class="quantity-add" type="button"><i
                                                        data-feather="plus"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="summary-item">
                                    <img src="{{ asset('img/pd.webp') }}" alt="Piaget Rose pendant" />
                                    <div class="item-info">
                                        <h4>Piaget Rose pendant</h4>
                                        <p class="item-desc">white gold diamond pendant</p>
                                        <p class="item-price">$ 2,630</p>
                                    </div>
                                    <div class="cart-quantity">
                                        <div class="pd-btn">
                                            <div class="pd-quantity">
                                                <button class="quantity-less" type="button"><i
                                                        data-feather="minus"></i></button>
                                                <span class="quantity-count"><input type="text" value="1"
                                                        min="1" pattern="[0-9]*" inputmode="numeric"
                                                        class="quantity-input"></span>
                                                <button class="quantity-add" type="button"><i
                                                        data-feather="plus"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="summary-item">
                                    <img src="{{ asset('img/pd.webp') }}" alt="Piaget Rose pendant" />
                                    <div class="item-info">
                                        <h4>Piaget Rose pendant</h4>
                                        <p class="item-desc">pendant, ethical white gold, diamonds</p>
                                        <p class="item-price">$ 2,630</p>
                                    </div>
                                    <div class="cart-quantity">
                                        <div class="pd-btn">
                                            <div class="pd-quantity">
                                                <button class="quantity-less" type="button"><i
                                                        data-feather="minus"></i></button>
                                                <span class="quantity-count"><input type="text" value="1"
                                                        min="1" pattern="[0-9]*" inputmode="numeric"
                                                        class="quantity-input"></span>
                                                <button class="quantity-add" type="button"><i
                                                        data-feather="plus"></i></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <hr />


                            <div class="coupon-area">
                                <!--  <label for="">
                                        Apply Coupon
                                    </label> -->
                                <div class="coupon-btn-input">
                                    <input type="text" placeholder="Enter Coupon Code" class="coupon-input">
                                    <button class="apply-coupon-btn">Apply</button>
                                </div>
                            </div>
                            <div class="summary-totals">
                                <div class="subtotal">
                                    <strong>Sub Total :</strong>
                                    <strong>$ 7,890</strong>
                                </div>
                                <div class="discount">
                                    <span>Discount :</span>
                                    <span>$ 1,000</span>
                                </div>
                                <div class="tax">
                                    <span>Tex :</span>
                                    <span>$0 1,000</span>
                                </div>
                                <div class="shipping">
                                    <span>Shipping :</span>
                                    <span>$ 100</span>
                                </div>
                                <hr />
                                <div class="total">
                                    <strong>Total :</strong>
                                    <strong>$ 7,890</strong>
                                </div>
                            </div>

                            <button class="place-order-btn">Place Order</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>



    </div>

    <!-- Modal -->
    <div class="modal fade" id="shipping-addres" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="exampleModalLabel">Add Shipping Address</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="">
                    <div class="modal-body">
                        <div class="shipping-form">
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="" style="margin-top:0;">First Name</label>
                                        <input type="text" class="form-control" placeholder="">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="">Last Name</label>
                                        <input type="text" class="form-control" placeholder="">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="">Mobile No.</label>
                                        <input type="text" class="form-control" placeholder="">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="">Email</label>
                                        <input type="text" class="form-control" placeholder="">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="">Address</label>
                                        <input type="text" class="form-control" placeholder="">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="">Landmark</label>
                                        <input type="text" class="form-control" placeholder="">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-4 col-sm-6 col-xs-6">
                                    <div class="form-group">
                                        <label for="">City</label>
                                        <select name="" id="" class="form-control">
                                            <option value="">--Select--</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-4 col-sm-6 col-xs-6">
                                    <div class="form-group">
                                        <label for="">Zip Code</label>
                                        <input type="text" class="form-control" placeholder="">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-4 col-sm-6 col-xs-6">
                                    <div class="form-group">
                                        <label for="">State</label>
                                        <select name="" id="" class="form-control">
                                            <option value="">--Select--</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-4 col-sm-6 col-xs-6">
                                    <div class="form-group">
                                        <label for="">Country</label>
                                        <select name="" id="" class="form-control">
                                            <option value="">--Select--</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-4 col-sm-6 col-xs-6">
                                    <div class="form-group">
                                        <a href="#" target="_blank" class="go-to-map">
                                            Choose On Map
                                            <span>
                                                <i data-feather="arrow-right"></i>
                                            </span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary">Save</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
