@extends('layout.main')

@section('title', 'Register')

@section('content')
    <div class="page-content cart-page log-in-page">
        <div class="cart-list cart-new register-page">
            <div class="cart-side-img">
                <div class="cart-img">
                    <img src="{{ asset('img/cart.jpg') }}" alt="">
                </div>
            </div>
            <div class="login-section">
                <form method="POST" action="{{ route('register') }}" class="register-box login-box">
                    @csrf
                    <h2>
                        Register
                    </h2>
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="">First Name</label>
                                <input type="text" class="form-control" name="first_name" placeholder="">
                            </div>
                            @error('first_name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="">Last Name</label>
                                <input type="text" class="form-control" name="last_name" placeholder="">
                            </div>
                            @error('last_name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>


                        <div class="col-sm-12">
                            <div class="form-group">
                                <label for="">Email</label>
                                <input type="text" class="form-control" name="email" placeholder="">
                            </div>
                            @error('email')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="phone">Mobile No</label>
                                <input type="tel" id="phone" class="form-control" name="mobile" placeholder="">
                            </div>
                            @error('mobile')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="">Country</label>
                                <select name="country" id="" class="form-control">
                                    <option value="">--Select--</option>
                                    @foreach ($countries as $country)
                                        <option value="{{ $country->id }}">{{ $country->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @error('country')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="">Password</label>
                                <input type="text" class="form-control" name="password" placeholder="">
                            </div>
                            @error('password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="">Confirm Password</label>
                                <input type="text" class="form-control" name="password_confirmation" placeholder="">
                            </div>
                            @error('password_confirmation')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="terms-line">
                            <div class="form-group remember-check">
                                <input type="checkbox" class="checkbox" name="terms" placeholder="" required>
                                <label for="">“I have read and agree to the <a href="#">Terms and
                                        Conditions</a> and <a href="#">Privacy Policy</a> .</label>
                            </div>
                            @error('terms')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="rebutton">
                            <button type="submit">
                                Submit
                            </button>
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
