@extends('layout.main')

@section('title', 'Login')

@section('content')
    <div class="page-content cart-page log-in-page">

        <div class="cart-list cart-new ">
            <div class="cart-side-img">
                <div class="cart-img">
                    <img src="{{ asset('img/cart.jpg') }}" alt="">
                </div>
            </div>
            <div class="login-section">
                <div class="login-box">
                    <h2>
                        Log In
                    </h2>
                    <div class="form-group">
                        <label for="" style="margin-top:0;">Email</label>
                        <input type="text" class="form-control" placeholder="">
                        @error('email')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="form-group" style="margin-bottom:0;">
                        <label for="">Password</label>
                        <input type="text" class="form-control" placeholder="">
                        @error('password')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="reset-pass-box">
                        <a class="forgot-line" href="{{ route('password.request') }}">
                            Forgot Password?
                        </a>
                    </div>
                    <button type="submit">
                        Log In
                    </button>

                    <div class="log-in-heading">
                        <span>
                            Login With
                        </span>
                    </div>
                    <div class="login-with-aap">

                        <span>
                            <div class="login-app">
                                <a href="#">
                                    <img src="{{ asset('img/google.png') }}" alt="">
                                </a>
                            </div>
                        </span>
                        <span>
                            <div class="login-app">
                                <a href="#">
                                    <img src="{{ asset('img/facebook.png') }}" alt="">
                                </a>
                            </div>
                        </span>
                    </div>
                    <div class="register-line-box">
                        Do not have an account? <a href="{{ route('register') }}">
                            Register</a>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection