$(document).ready(function() {

  const $video = $("#heroVideo");
  const $playPauseBtn = $("#playPauseBtn");
  const $muteBtn = $("#muteBtn");

  // Initialize icons
  feather.replace();

  $playPauseBtn.on("click", function () {
    if ($video.get(0).paused) {
      $video.get(0).play();
      $playPauseBtn.html('<i data-feather="pause"></i>');
    } else {
      $video.get(0).pause();
      $playPauseBtn.html('<i data-feather="play"></i>');
    }
    feather.replace(); // Re-render the new icon
  });

  $muteBtn.on("click", function () {
    const isMuted = $video.prop("muted");
    $video.prop("muted", !isMuted);
    const icon = isMuted ? "volume-x" : "volume-2";
    $muteBtn.html('<i data-feather="' + icon + '"></i>');
    feather.replace(); // Re-render the new icon
  });

  // Initialize Slick for category slider
  $('.category-slider').slick({
    infinite: true,
    slidesToShow: 4,
    slidesToScroll: 1,
    arrows: false,
    prevArrow:"<button type='button' class='slick-prev-btn pull-left '><i data-feather='chevron-left'></i></button>",
    nextArrow:"<button type='button' class='slick-next-btn pull-right'><i data-feather='chevron-right'></i></button>",
    
    responsive: [
      {
        breakpoint: 1280,
        settings: {
          slidesToShow: 3,
        }
      },
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 3,
        }
      },
      {
        breakpoint: 641,
        settings: {
          slidesToShow: 2,
        }
      },
      {
        breakpoint: 0,
        settings: {
          slidesToShow: 1,
        }
      }
    ]
  });



$('.product-slider').slick({
    infinite: true,
    slidesToShow: 4,
    slidesToScroll: 1,
     arrows: false,
  /*  prevArrow:"<button type='button' class='slick-prev-btn pull-left '><i data-feather='chevron-left'></i></button>",
    nextArrow:"<button type='button' class='slick-next-btn pull-right'><i data-feather='chevron-right'></i></button>", */
    
    responsive: [
      {
        breakpoint: 1290,
        settings: {
          slidesToShow: 3,
        }
      },
      {
        breakpoint: 992,
        settings: {
          slidesToShow: 3,
        }
      },
      {
        breakpoint: 800,
        settings: {
          slidesToShow: 2,
        }
      },
      {
        breakpoint: 500,
        settings: {
          slidesToShow: 1,
        }
      },
      {
        breakpoint: 380,
        settings: {
          slidesToShow: 1,
        }
      }
    ]
  });



$('.s-item-slider').slick({
  slidesToShow: 1,
  slidesToScroll: 1,
  fade: true,
  asNavFor: '.s-product-slider',
  adaptiveHeight: true,
  lazyLoad: 'ondemand',
  swipe: true,
  touchMove: true,
  accessibility: true,
  arrows: false,
});

$('.s-product-slider').slick({
  slidesToShow: 1,
  slidesToScroll: 1,
  asNavFor: '.s-item-slider',
  dots: true,
  centerMode: false,
  focusOnSelect: true,
  arrows: false,
  infinite: true,
  lazyLoad: 'ondemand',
  swipe: true,
  touchMove: true,
  accessibility: true,
 
});

  feather.replace();


 function setVideoHeights() {
    var $bvideoMain = $('.bvideo-main');
    var $bvideo1 = $('.hvideo1');
    var $bvideo2 = $('.hvideo2');

    if ($bvideoMain.length && $bvideo1.length && $bvideo2.length) {
      var mainHeight = $bvideoMain.outerHeight();
      var marginBetween = parseInt($bvideo1.css('margin-bottom')) || 0;

      var halfHeight = (mainHeight - marginBetween) / 2;

      $bvideo1.height(halfHeight);
      $bvideo2.height(halfHeight);
    }
  }

  $(document).ready(function () {
    setVideoHeights();

    $(window).on('resize', function () {
      setVideoHeights();
    });
  });




  // Toggle mobile menu popup on click of mobileMenuToggle
  $('#mobileMenuToggle').on('click', function(e) {
    e.preventDefault();
    $('#mobileMenuPopup').toggleClass('active');
    $('#mobileMenuOverlay').toggle();
  });

  // Hide mobile menu popup and overlay when clicking outside of it and the toggle button
  $(document).on('click', function(e) {
    var $popup = $('#mobileMenuPopup');
    var $toggle = $('#mobileMenuToggle');
    var $overlay = $('#mobileMenuOverlay');
    if (!$popup.is(e.target) && $popup.has(e.target).length === 0 &&
        !$toggle.is(e.target) && $toggle.has(e.target).length === 0) {
      $popup.removeClass('active');
      $overlay.hide();
    }
  });

// Close mobile menu popup and overlay on clicking close button
  $('#mobileMenuClose').on('click', function(e) {
    e.preventDefault();
    $('#mobileMenuPopup').removeClass('active');
    $('#mobileMenuOverlay').hide();
  });




   $(window).on('scroll', function() {
    var headerHeight = $('header').outerHeight();
    var scrollTop = $(window).scrollTop();
    var $header = $('header');

    if (scrollTop >= headerHeight + 150) {
      if (!$header.hasClass('sticky')) {
        
        $header.css({
          transform: 'translateY(-100%)',
          transition: 'none'
        });
        
        $header[0].offsetHeight;
        
        $header.addClass('sticky').css({
          transform: 'translateY(0)',
          transition: 'transform 400ms ease'
        });
      }
    } else if (scrollTop === 0) {
      if ($header.hasClass('sticky')) {
        
        $header.css({
          transform: 'translateY(-100%)',
          transition: 'none'
        });
        
        $header.removeClass('sticky').css({
          transform: '',
          transition: ''
        });
      }
    }
  });




  

  function setBannerPadding() {
    var headerHeight = $('header').outerHeight();
    $('.banner, .page-content').css('margin-top', headerHeight + 'px');
  }

  setBannerPadding();

  $(window).on('resize', function() {
    setBannerPadding();
  });

 


// scroll-header

  var scrollHeader = $('.scroll-header');

  if (scrollHeader.length === 0) return;

  $(window).scroll(function () {
    if ($(window).scrollTop() > 400) {
      scrollHeader.addClass('active');
    } else {
      scrollHeader.removeClass('active');
    }
  });



$('#search').click(function() {
  $('.search-form').animate({ top: 0 }, 200);
  $('.search-popup').show();

  // Close when background is clicked
  $('.search-bg').click(function() {
    $('.search-popup').hide();
    $('.search-form').animate({ top: '-100%' }, 200);
  });

  // Close when menu close button is clicked
  $('.search-menu-close').click(function() {
    $('.search-popup').hide();
    $('.search-form').animate({ top: '-100%' }, 200);
  });
});










// filter dropdown 

    // Toggle dropdown and icons on click
$('.filter-name').click(function(e) {
  e.stopPropagation(); // Prevent click from bubbling to document

  const $this = $(this);
  const isOpen = $this.hasClass('open');

  // Close all others before toggling
  $('.filter-name').not($this).removeClass('open').find('.filter-dropdown').hide();
  $('.filter-name').not($this).find('.down-filter').show();
  $('.filter-name').not($this).find('.up-filter').hide();

  if (!isOpen) {
    $this.addClass('open');
    $this.find('.filter-dropdown').show();
    $this.find('.down-filter').hide();
    $this.find('.up-filter').show();
  }
});

// Prevent closing when clicking inside dropdown
$('.filter-dropdown').click(function(e) {
  e.stopPropagation();
});

// Close dropdown when clicking outside
$(document).click(function() {
  $('.filter-name').removeClass('open');
  $('.filter-dropdown').hide();
  $('.down-filter').show();
  $('.up-filter').hide();
});




// PRICE FILTER



const priceGap = 1000;

const $rangeInput = $(".range-input input"),
      $priceInput = $(".price-input input"),
      $range = $(".slider .progress");

const maxAttr = parseInt($rangeInput.eq(1).attr("max")) || 10000;

// Set min value explicitly to 0
$rangeInput.attr("min", 0);

// Price input change
$priceInput.on("input", function () {
  let minPrice = parseInt($priceInput.eq(0).val()) || 0,
      maxPrice = parseInt($priceInput.eq(1).val()) || 0;

  if (maxPrice - minPrice >= priceGap && maxPrice <= maxAttr) {
    if ($(this).hasClass("input-min")) {
      $rangeInput.eq(0).val(minPrice);
      $range.css("left", (minPrice / maxAttr) * 100 + "%");
    } else {
      $rangeInput.eq(1).val(maxPrice);
      $range.css("right", 100 - (maxPrice / maxAttr) * 100 + "%");
    }
  }
});



// Range slider change
$rangeInput.on("input", function () {
  let minVal = parseInt($rangeInput.eq(0).val()) || 0,
      maxVal = parseInt($rangeInput.eq(1).val()) || 0;

  if (maxVal - minVal < priceGap) {
    if ($(this).hasClass("range-min")) {
      $rangeInput.eq(0).val(maxVal - priceGap);
    } else {
      $rangeInput.eq(1).val(minVal + priceGap);
    }
  } else {
    $priceInput.eq(0).val(minVal);
    $priceInput.eq(1).val(maxVal);
    $range.css("left", (minVal / maxAttr) * 100 + "%");
    $range.css("right", 100 - (maxVal / maxAttr) * 100 + "%");
  }
});




// filter


  // Existing: Handle checkbox tag creation
  $('.filter-input').on('change', function () {
    const label = $(this).siblings('label').text().trim();
    const id = label.toLowerCase().replace(/\s+/g, '-');

    if ($(this).is(':checked')) {
      $('.filter-by-header').show();

      if (!$(`.filter-teg[data-id="${id}"]`).length) {
        $('.filter-tag-box').append(`
          <div class="filter-teg" data-id="${id}">
            <span class="teg-name">${label}</span>
            <span class="tag-icon"><i data-feather="x"></i></span>
          </div>
        `);
        feather.replace();
      }
    } else {
      $(`.filter-teg[data-id="${id}"]`).remove();
      if ($('.filter-teg').length === 0) {
        $('.filter-by-header').hide();
      }
    }
  });

  // ✅ New: Handle price Apply button click
  $('.price-filter-btn button').on('click', function () {
    const minPrice = $('.input-min').val();
    const maxPrice = $('.input-max').val();
    const priceId = `price-${minPrice}-${maxPrice}`;

    if (!$(`.filter-teg[data-id="${priceId}"]`).length) {
      $('.filter-by-header').show();
      $('.filter-tag-box').append(`
        <div class="filter-teg" data-id="${priceId}">
          <span class="teg-name">${minPrice} - ${maxPrice}</span>
          <span class="tag-icon"><i data-feather="x"></i></span>
        </div>
      `);
      feather.replace();
    }
  });

  // Remove tag and uncheck related checkbox
  $(document).on('click', '.filter-teg .tag-icon', function () {
    const $tag = $(this).closest('.filter-teg');
    const id = $tag.data('id');

    // Remove tag
    $tag.remove();

    // Uncheck matching checkboxes (skip price filter)
    $('.filter-dropdown label').each(function () {
      if ($(this).text().trim().toLowerCase().replace(/\s+/g, '-') === id) {
        $(this).siblings('input[type="checkbox"]').prop('checked', false);
      }
    });

    if ($('.filter-teg').length === 0) {
      $('.filter-by-header').hide();
    }
  });

  $('.filter-by-header').hide();














  // Pagination for product items




  function paginateProducts(itemsPerPage) {
    var $productList = $('#product-list > div.col-lg-3');
    var totalItems = $productList.length;
    var totalPages = Math.ceil(totalItems / itemsPerPage);
    var $paginationContainer = $('#pagination-container');
    var currentPage = 1;

    function showPage(page) {
      if (page < 1) page = 1;
      if (page > totalPages) page = totalPages;
      currentPage = page;

      $productList.hide();
      var start = (page - 1) * itemsPerPage;
      var end = start + itemsPerPage;
      $productList.slice(start, end).show();

      // Update product count display
      var startCount = start + 1;
      var endCount = Math.min(end, totalItems);
      $('.product-count').text('Showing ' + startCount + ' - ' + endCount + ' of ' + totalItems + ' Items');

      // Update pagination controls
      $paginationContainer.empty();

      if (currentPage > 1) {
        $paginationContainer.append('<li class="page-item"><a class="page-link" href="#" data-page="' + (currentPage - 1) + '">&laquo;</a></li>');
      }

      for (var i = 1; i <= totalPages; i++) {
        var activeClass = (i === currentPage) ? 'active' : '';
        $paginationContainer.append('<li class="page-item ' + activeClass + '"><a class="page-link" href="#" data-page="' + i + '">' + i + '</a></li>');
      }

      if (currentPage < totalPages) {
        $paginationContainer.append('<li class="page-item"><a class="page-link" href="#" data-page="' + (currentPage + 1) + '">&raquo;</a></li>');
      }
    }

    $paginationContainer.on('click', 'a.page-link', function(e) {
      e.preventDefault();
      var page = parseInt($(this).data('page'));
      showPage(page);
    });

    showPage(1);
  }

  // Initialize pagination with 8 items per page
  paginateProducts(16);

  // Initialize product detail image sliders
  $('.pd-nav-img-slider').slick({
    slidesToShow: 5,
    slidesToScroll: 1,
    asNavFor: '.pd-main-img-slider',
    dots: false,
    centerMode: false,
    focusOnSelect: true,
     vertical: true, 
     verticalSwiping: true, 
    arrows: false,
    infinite: true,
    adaptiveHeight: true,
    responsive: [
      {
        breakpoint: 768,
        settings: {
           vertical: false,
          verticalSwiping: false, 
          slidesToShow: 3
        }
      },
      {
        breakpoint: 480,
        settings: {
         vertical: false,
          verticalSwiping: false, 
          slidesToShow: 2
        }
      }
    ]
  });

  $('.pd-main-img-slider').slick({
    slidesToShow: 1,
    slidesToScroll: 1,
    arrows: false,
    fade: true,
    asNavFor: '.pd-nav-img-slider',
    infinite: true,
    /* adaptiveHeight: true */
  });



  // Quantity Counter Functionality

  // Initialize quantity counter
  function initQuantityCounter() {
    const $quantityInput = $('.quantity-input');
    const $addBtn = $('.quantity-add');
    const $lessBtn = $('.quantity-less');
    
    // Set default value to 1
    $quantityInput.val(1);
    
    // Function to update quantity
    function updateQuantity($input, change) {
      let currentValue = parseInt($input.val()) || 0;
      let newValue = currentValue + change;
      
      // Ensure value is always positive
      newValue = Math.max(1, newValue);
      
      $input.val(newValue);
    }
    
    // Add button click handler
    $addBtn.on('click', function() {
      const $input = $(this).closest('.pd-quantity').find('.quantity-input');
      updateQuantity($input, 1);
    });
    
    // Less button click handler
    $lessBtn.on('click', function() {
      const $input = $(this).closest('.pd-quantity').find('.quantity-input');
      updateQuantity($input, -1);
    });
    
    // Input validation - only allow numbers
    $quantityInput.on('input', function() {
      let value = $(this).val();
      // Remove non-numeric characters
      value = value.replace(/[^0-9]/g, '');
      // Ensure minimum value of 1
      value = Math.max(1, parseInt(value) || 1);
      $(this).val(value);
    });
    
    // Handle paste events
    $quantityInput.on('paste', function(e) {
      e.preventDefault();
      const pastedData = (e.originalEvent || e).clipboardData.getData('text/plain');
      const numericValue = parseInt(pastedData.replace(/[^0-9]/g, '')) || 1;
      $(this).val(Math.max(1, numericValue));
    });
    
    // Handle keydown to prevent invalid characters
    $quantityInput.on('keydown', function(e) {
      // Allow: backspace, delete, tab, escape, enter, arrows
      if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 37, 39]) !== -1 ||
          (e.keyCode >= 48 && e.keyCode <= 57) || // numbers
          (e.keyCode >= 96 && e.keyCode <= 105)) { // numpad numbers
        return;
      }
      e.preventDefault();
    });
  }
  
  // Initialize when DOM is ready
  initQuantityCounter();


// character limit
function limitTextLength() {
  $('.limited-text').each(function () {
    var maxLength = 40; 
    var text = $(this).text();
    if (text.length > maxLength && !$(this).hasClass('processed')) {
      var trimmedText = text.substring(0, maxLength) + '...';
      $(this).text(trimmedText).addClass('processed');
    }
  });

  $('.limited-p-name').each(function () {
    var maxLength = 30; 
    var text = $(this).text();
    if (text.length > maxLength && !$(this).hasClass('processed')) {
      var trimmedText = text.substring(0, maxLength) + '...';
      $(this).text(trimmedText).addClass('processed');
    }
  });
}

// Run when DOM is ready
$(document).ready(function() {
  limitTextLength();
});

// Run when content changes (for dynamic content)
$(document).on('DOMNodeInserted', function() {
  limitTextLength();
});

// Alternative: Use MutationObserver for better performance
if (window.MutationObserver) {
  var observer = new MutationObserver(function(mutations) {
    mutations.forEach(function(mutation) {
      if (mutation.addedNodes.length > 0) {
        limitTextLength();
      }
    });
  });
  
  observer.observe(document.body, {
    childList: true,
    subtree: true
  });
}


  //remove cart

$(document).on('click', '.remove-cart-item', function () {
  $(this).closest('tr').remove();
});


// open cart

$('.open-cart-popup').on('click', function () {
    $('.cart-popup').addClass('active');
    $('.cartoverlay').addClass('active');
});

// Close cart (close button)
$('.cart-popup-close').on('click', function () {
    $('.cart-popup').removeClass('active');
    $('.cartoverlay').removeClass('active');
});

// Close cart when clicking overlay (outside cart)
$('.cartoverlay').on('click', function () {
    $('.cart-popup').removeClass('active');
    $(this).removeClass('active');
});




// wishilist
$('.wishlist-btn').on('click', function () {
    $(this).toggleClass('active');
});

// Cart image functionality - when clicking on .cart-product-image, show .cart-slide-img in .cart-img img
$(document).on('click', '.cart-product-image', function() {
  const slideImg = $(this).find('.cart-slide-img').attr('src');
  if (slideImg) {
    $('.cart-img img').attr('src', slideImg);
  }
});


$('.video-call').on('click', function () {
    $('#vc-modal').modal('show');
});

});




