$(document).ready(function() {
    // Cart Popup Functionality
    function openCartPopup() {
        $('.cart-popup').addClass('active');
        $('body').addClass('cart-popup-open');
    }

    function closeCartPopup() {
        $('.cart-popup').removeClass('active');
        $('body').removeClass('cart-popup-open');
    }

    // Handle click on open-cart-popup elements
    $(document).on('click', '.open-cart-popup', function(e) {
        e.preventDefault();
        e.stopPropagation();
        openCartPopup();
    });

    // Close cart popup when clicking close button
    $(document).on('click', '.cart-popup-close', function(e) {
        e.preventDefault();
        closeCartPopup();
    });

    // Close cart popup when clicking outside
    $(document).on('click', '.cart-popup', function(e) {
        if (e.target === this) {
            closeCartPopup();
        }
    });

    // Prevent closing when clicking inside popup content
    $(document).on('click', '.cart-popup-content', function(e) {
        e.stopPropagation();
    });

    // Close cart popup with ESC key
    $(document).on('keydown', function(e) {
        if (e.keyCode === 27) {
            closeCartPopup();
        }
    });
});
