<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'stock_id',
        'product_name',
        'item_no',
        'design_no',
        'stone',
        'setting',
        'finding',
        'labor',
        'metal',
        'overhead',
        'cost_price',
        'designer',
        'vendor_code',
        'vendor_sku',
        'client_ref_no',
        'category_id',
        'sub_category_id',
        'collection_id',
        'metal_purity_id',
        'size_id',
        'dimension',
        'inventory_uom_id',
        'multi_metal_id',
        'gross_wt',
        'net_wt',
        'fine_wt',
        'wastage_percentage',
        'product_type_id',
        'location_id',
        'fix_price_id',
        'unit_price',
        'price_group_id',
        'company_id',
        'status_id',
        'show_in_repair_id',
        'product_description',
        'product_image',
        'product_image_additional',
        'markup',
        'oz_price',
        'metal_price',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'stone' => 'decimal:2',
        'setting' => 'decimal:2',
        'finding' => 'decimal:2',
        'labor' => 'decimal:2',
        'metal' => 'decimal:2',
        'overhead' => 'decimal:2',
        'cost_price' => 'decimal:2',
        'gross_wt' => 'decimal:3',
        'net_wt' => 'decimal:3',
        'fine_wt' => 'decimal:3',
        'wastage_percentage' => 'decimal:2',
        'unit_price' => 'decimal:2',
        'markup' => 'decimal:2',
        'oz_price' => 'decimal:2',
        'metal_price' => 'decimal:2',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Get the category that owns the product.
     */
    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    /**
     * Get the subcategory that owns the product.
     */
    public function subCategory()
    {
        return $this->belongsTo(SubCategory::class, 'sub_category_id');
    }

    /**
     * Get the collection that owns the product.
     */
    public function collection()
    {
        return $this->belongsTo(Collection::class);
    }

    /**
     * Get the metalPurity that owns the product.
     */
    public function metalPurity()
    {
        return $this->belongsTo(MetalPurity::class);
    }

    /**
     * Get the size that owns the product.
     */
    public function size()
    {
        return $this->belongsTo(Size::class);
    }

    /**
     * Get the inventory UOM that owns the product.
     */
    public function inventoryUom()
    {
        return $this->belongsTo(InventoryUom::class, 'inventory_uom_id');
    }

    /**
     * Get the metal that owns the product.
     */
    public function metal()
    {
        return $this->belongsTo(Metal::class, 'multi_metal_id', 'id');
    }

    /**
     * Get the product type that owns the product.
     */
    public function productType()
    {
        return $this->belongsTo(ProductType::class);
    }

    /**
     * Get the location that owns the product.
     */
    public function location()
    {
        return $this->belongsTo(Location::class);
    }

    /**
     * Get the fix price that owns the product.
     */
    public function fixPrice()
    {
        return $this->belongsTo(FixPrice::class);
    }

    /**
     * Get the price group that owns the product.
     */
    public function priceGroup()
    {
        return $this->belongsTo(PriceGroup::class);
    }
}
